*! version 5.0
* 13 August 2018
* NIDS
* Master Wealth do file for Nids Wave 2

* THIS IS 4th WEALTH DO FILE - PERFORMING IMPUTATIONS FOR MISSING DATA: 4 OF 6
* THIS DO FILE PERFORMS IMPUTATIONS FOR MISSING DATA ON THE RELEVANT WEALTH VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Wealth do file (1 of 6)"

version 12.0

*=====================================================================================================================================

* OPENING DATASET PREPARED IN PRIOR DO FILE "Wealth - Preparing variables for imputation (3 of 6).DO"

set more off

use "$DataOUT\prepdata.dta", clear 

*-------------------------------------------------------------------------------------------------------------------------------------

*The "regimp" routine
cap program drop regimp
program define regimp
	gettoken depvar 0: 0
	local regressors "`0'"
	tempvar lndepvar
	gen `lndepvar'=ln(`depvar')
	xi:regress `lndepvar' `regressors'
	tempvar lndepvar_fit
	predict `lndepvar_fit'
	gen `depvar'_fit=exp(`lndepvar_fit')
	gen `depvar'_imp=`depvar'
	replace `depvar'_imp=`depvar'_fit if `depvar'==. & `depvar'_rec==1 & `depvar'_fit!=.
	gen `depvar'_data=0 if `depvar'_rec==1 & `depvar'!=.
	replace `depvar'_data=1 if `depvar'_rec==1 & `depvar'==. & `depvar'_fit!=.
	replace `depvar'_data=1 if `depvar'_rec==1 & `depvar'==. & `depvar'_imp!=.
	replace `depvar'_data=2 if `depvar'_rec==1 & `depvar'_imp==.
	label define `depvar'_data 0 "Survey" 1 "Imputed" 2 "Not imputed"
	label values `depvar'_data `depvar'_data
end

mvdecode _all, mv(-3=.)

*RUNNING THE INDIVIDUAL-LEVEL REGRESSIONS
foreach var of varlist busass busdeb priveh bakkie scooter vehdebt cash bank life stocks bankdebt ///
micro masho studentloan otherstudentloan creditcard store hirep famloan friendloan emploan ///
unpaidtax pension {
	quietly count if `var'_d==1
		if r(N)>=100 {
			regimp `var' male race_d coloured asian_indian white w2_best_age_yrs age_d agesq tradeunion ///
schooling schoolingsq cert_nomat dip_nomat cert_mat dip_mat bachelors bach_dip honours postgrad ///
roster_married homerooms homeroomssq homerooms_d i.intmonth i.province i.geo2011
		quietly sum `var'_data
		if r(mean)>0.4 {
			replace `var'_imp=. if `var'_data==1
			lab def `var'_data 0 "Survey" 1 "Not imputed", modify
				}
		else {
				}
		}
				else {
					gen `var'_imp=`var'
					gen `var'_data=0 if `var'_rec==1
					replace `var'_data=1 if `var'_rec==1 & `var'_imp==.
					lab def `var'_data 0 "Survey" 1 "Not imputed", modify
					lab val `var'_data `var'_data
						}
			}


*RUNNING THE HOUSEHOLD-LEVEL REGRESSIONS
sort w2_hhid
foreach var of varlist houseval otherhouseval housedebt otherhousedebt ///
cattle sheep goats pigs horses donkeys chickens {
    replace `var'_d=. if w2_hhid==w2_hhid[_n-1]
	quietly count if `var'_d==1
		if r(N)>=100 {
			regimp `var' i.hometype i.homewalls i.homeroof homerooms i.hhrace hhrace_d ///
			hhedu hhedusq i.hhintmonth hhage hhage_d hhtu if w2_hhid!=w2_hhid[_n-1]
		quietly sum `var'_data
		if r(mean)>0.4 {
			replace `var'_imp=. if `var'_data==1
			lab def `var'_data 0 "Survey" 1 "Not imputed", modify
				}
		else {
				}
		}
				else {
					gen `var'_imp=`var'
					gen `var'_data=0 if `var'_rec==1
					replace `var'_data=1 if `var'_rec==1 & `var'_imp==.
					lab def `var'_data 0 "Survey" 1 "Not imputed", modify
					lab val `var'_data `var'_data
						}
			}
			
save "$DataOUT\impdata.dta", replace
*******

* end of do file
*========================================================================================================================================
